/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.palette;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepPaletteDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.palette.VWBaseStepPalettePanel;
import filenet.vw.toolkit.design.palette.VWIconViewPanel;
import filenet.vw.toolkit.design.palette.VWStepPaletteItemUI;
import filenet.vw.toolkit.design.palette.VWStepPaletteWrapper;
import filenet.vw.toolkit.design.palette.VWSubIconViewPanel;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;

class VWScrollableIconViewPanel
extends VWIconViewPanel {
    private static final int GAP_HORIZONTAL = 3;
    private static final int GAP_VERTICAL = 3;
    private static final String DUMMY_LABEL_TEXT = " ";
    private Font m_smallFont = null;

    public VWScrollableIconViewPanel() {
        super((VWBaseStepPalettePanel)null);
        Font aFont = this.getFont();
        this.m_smallFont = new Font(aFont.getName(), 0, aFont.getSize() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void displayPalettes(VWStepPaletteWrapper[] stepPalettes) {
        try {
            try {
                this.removeAll();
                this.setLayout(new GridBagLayout());
                GridBagConstraints gbCons = new GridBagConstraints();
                gbCons.gridx = 0;
                gbCons.gridy = 0;
                gbCons.fill = 2;
                gbCons.weightx = 1.0;
                gbCons.weighty = 0.0;
                gbCons.anchor = 23;
                gbCons.gridheight = 1;
                gbCons.gridwidth = 1;
                gbCons.insets = new Insets(3, 3, 3, 3);
                if (stepPalettes != null) {
                    for (int nPaletteIndex = 0; nPaletteIndex < stepPalettes.length; ++nPaletteIndex) {
                        VWStepPaletteDefinition vwStepPaletteDefinition = stepPalettes[nPaletteIndex].getStepPaletteDefinition();
                        if (vwStepPaletteDefinition == null) continue;
                        gbCons.gridx = 0;
                        ++gbCons.gridy;
                        gbCons.fill = 2;
                        gbCons.weightx = 1.0;
                        gbCons.weighty = 0.0;
                        gbCons.gridwidth = 0;
                        JLabel label = new JLabel(vwStepPaletteDefinition.getName());
                        label.setComponentOrientation(this.getComponentOrientation());
                        label.setOpaque(true);
                        label.setBackground(VWToolbarBorder.BGCOLOR_LTGRAY);
                        this.add((Component)label, gbCons);
                        VWMapNode[] vwMapNodes = vwStepPaletteDefinition.getSteps();
                        if (vwMapNodes == null || vwMapNodes.length <= 0) continue;
                        Object[] spItems = new VWStepPaletteItemUI[vwMapNodes.length];
                        for (int nIndex = 0; nIndex < vwMapNodes.length; ++nIndex) {
                            spItems[nIndex] = this.makeItem(vwMapNodes[nIndex], stepPalettes[nPaletteIndex]);
                        }
                        VWQubbleSort.sort(spItems);
                        ++gbCons.gridy;
                        gbCons.fill = 0;
                        gbCons.weightx = 0.0;
                        gbCons.gridwidth = 0;
                        VWSubIconViewPanel stepsPanel = new VWSubIconViewPanel((VWStepPaletteItemUI[])spItems);
                        stepsPanel.setBackground(this.getBackground());
                        stepsPanel.applyComponentOrientation(this.getComponentOrientation());
                        this.add((Component)stepsPanel, gbCons);
                    }
                    gbCons.gridx = 0;
                    ++gbCons.gridy;
                    gbCons.fill = 1;
                    gbCons.weightx = 1.0;
                    gbCons.weighty = 0.1;
                    gbCons.anchor = 21;
                    gbCons.gridwidth = 0;
                    this.add((Component)new JLabel(DUMMY_LABEL_TEXT), gbCons);
                }
                this.calculateSize();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var10_12 = null;
                this.revalidate();
                this.repaint();
                return;
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.revalidate();
            this.repaint();
            throw throwable;
        }
        this.revalidate();
        this.repaint();
    }

    public void releaseReferences() {
        this.m_smallFont = null;
        super.releaseReferences();
    }

    protected VWStepPaletteItemUI makeItem(VWMapNode vwMapNode, VWStepPaletteWrapper stepPaletteWrapper) {
        VWStepPaletteItemUI uiItem = super.makeItem(vwMapNode, stepPaletteWrapper);
        if (uiItem != null) {
            uiItem.setText(vwMapNode.getName());
            uiItem.setHorizontalTextPosition(0);
            uiItem.setVerticalTextPosition(3);
            uiItem.setFont(this.m_smallFont);
        }
        return uiItem;
    }

    protected synchronized void calculateSize() {
        Dimension parentSize = this.getParent().getSize();
        int nComponentCount = this.getComponentCount();
        for (int i = 0; i < nComponentCount; ++i) {
            Component childComponent = this.getComponent(i);
            if (!childComponent.isVisible() || childComponent instanceof JLabel || !(childComponent instanceof VWSubIconViewPanel)) continue;
            VWSubIconViewPanel panel = (VWSubIconViewPanel)childComponent;
            panel.createControls(parentSize);
        }
    }

    protected void setStepPalettePanel(VWBaseStepPalettePanel stepPalettePanel) {
        this.m_stepPalettePanel = stepPalettePanel;
    }
}

